import 'package:get/get.dart';
import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/core/helper/shared_pref_helper.dart';
import 'package:play_lab/core/helper/string_format_helper.dart';
import 'package:play_lab/core/route/route.dart';
import 'package:play_lab/data/model/global/global_user_model.dart';
import 'package:play_lab/data/repo/account/profile_repo.dart';
import 'package:play_lab/view/components/show_custom_snackbar.dart';

class MyMenuController extends GetxController {
  ProfileRepo repo;
  MyMenuController({required this.repo});
  //
  bool isAuthorized() {
    String? value = repo.apiClient.sharedPreferences.getString(SharedPreferenceHelper.accessTokenKey);
    return value == null
        ? false
        : value.isEmpty
            ? false
            : true;
  }

  String getUserFullName() => repo.apiClient.sharedPreferences.getString(SharedPreferenceHelper.userFullNameKey) ?? '';
  String getUserEmail() => repo.apiClient.sharedPreferences.getString(SharedPreferenceHelper.userEmailKey) ?? '';
  String getUserImage() => repo.apiClient.sharedPreferences.getString(SharedPreferenceHelper.userImageKey) ?? '';
  bool isPaidUser() => repo.apiClient.isPaidUser();
  GlobalUser? user;
  Future<void> getProfileInfo() async {
    printX("CALL-- ${DateTime.now().second}");
    final response = await repo.loadProfileInfo();
    if (response.status == "success") {
      user = response.data?.user;
      update();
      if (user != null) {
        await repo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.userFullNameKey, '${user?.firstName ?? ''} ${user?.lastName ?? ''}');
        await repo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.userEmailKey, user?.email ?? '');
        await repo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.userImageKey, user?.image ?? '');
      }
    } else {
      //
    }
  }

  bool isLogoutLoading = false;
  void logOutUser() async {
    isLogoutLoading = true;
    update();
    try {
      final status = await repo.logout();

      if (status) {
        repo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.accessTokenKey, '');
        repo.apiClient.sharedPreferences.setBool(SharedPreferenceHelper.rememberMeKey, false);
        repo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.accessTokenType, '');
        Get.toNamed(RouteHelper.loginScreen);
        CustomSnackbar.showCustomSnackbar(errorList: [], msg: [MyStrings.logoutSuccessMsg], isError: false);
      }
    } catch (e) {
      isLogoutLoading = false;
      update();
    }
    isLogoutLoading = false;
    update();
  }

  bool isDeleteLoading = false;
  void deleteAccount() async {
    isDeleteLoading = true;
    update();
    try {
      final status = await repo.deleteAccount();
      if (status) {
        repo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.accessTokenKey, '');
        repo.apiClient.sharedPreferences.setBool(SharedPreferenceHelper.rememberMeKey, false);
        repo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.accessTokenType, '');
        Get.toNamed(RouteHelper.loginScreen);
        CustomSnackbar.showCustomSnackbar(errorList: [], msg: [MyStrings.deleteSuccessMsg], isError: false);
      }
    } catch (e) {
      isDeleteLoading = false;
      update();
    }
    isDeleteLoading = false;
    update();
  }
}
